/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.enums.GroupTypeEnum;
import sk.rastsoft.eindexer.enums.OperationTypeEnum;
import sk.rastsoft.eindexer.enums.StatusTypeEnum;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.lucene.LuceneBase;
import sk.rastsoft.lucene.LuceneWriter;
import sk.rastsoft.lucene.defs.ILuceneReader;
import sk.rastsoft.lucene.defs.SearchCriteria;

public class LuceneReader
extends LuceneBase
implements ILuceneReader {
    private IndexReader reader;
    private TypeOfIndexEnum indexType;

    public LuceneReader(TypeOfIndexEnum indexType) {
        this.indexType = indexType;
        try {
            this.reader = this.getReader(this.indexType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<RecordDataDTO> searchData(SearchCriteria criteria) throws ParseException, IOException {
        ArrayList<RecordDataDTO> list = new ArrayList<RecordDataDTO>();
        Query q = LuceneReader.getQuery(criteria);
        IndexSearcher searcher = new IndexSearcher(this.reader);
        Sort sort = new Sort(new SortField("createDate", SortField.Type.LONG, true));
        TopFieldDocs terms = searcher.search(q, criteria.getMaxItems(), sort);
        ScoreDoc[] hits = terms.scoreDocs;
        System.out.println("Found " + hits.length + " hits.");
        for (int i = 0; i < hits.length; ++i) {
            int docId = hits[i].doc;
            Document d = searcher.doc(docId);
            list.add(LuceneReader.getRecordData(d));
        }
        return list;
    }

    private IndexReader getReader(TypeOfIndexEnum indexType) throws IOException {
        Directory dir;
        if (this.reader != null) {
            this.close();
        }
        if (!DirectoryReader.indexExists((Directory)(dir = this.openIndex(indexType)))) {
            LuceneWriter writer = new LuceneWriter(indexType);
            writer.close();
            System.out.println("New index created...");
        }
        this.reader = DirectoryReader.open((Directory)dir);
        return this.reader;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        this.reader = null;
    }

    private static RecordDataDTO getRecordData(Document d) {
        RecordDataDTO data = new RecordDataDTO();
        int currVersion = 0;
        String versionStr = d.get("version");
        if (versionStr != null) {
            currVersion = Integer.parseInt(versionStr);
        }
        data.setVersion(3);
        data.setDocId(Integer.parseInt(d.get("index")));
        data.setDecription(d.get("desc"));
        data.setCategory(GroupTypeEnum.getType(Integer.parseInt(d.get("category"))));
        data.setFilePath(d.get("path"));
        data.setIndexDate(new Date(Long.parseLong(d.get("indexDate"))));
        data.setCreationDate(new Date(Long.parseLong(d.get("createDate"))));
        if (currVersion > 0) {
            data.setOpType(OperationTypeEnum.getType(Integer.parseInt(d.get("operation"))));
        }
        if (currVersion > 1) {
            data.setLastModified(Long.parseLong(d.get("fileLM")));
            data.setLength(Long.parseLong(d.get("fileLength")));
            data.setCrc(Long.parseLong(d.get("fileCRC")));
        }
        if (currVersion > 2) {
            data.setState(StatusTypeEnum.getType(Integer.parseInt(d.get("state"))));
        }
        return data;
    }

    private static Query getQuery(SearchCriteria criteria) throws ParseException {
        Query q;
        BooleanQuery bQuery = new BooleanQuery();
        List<String> words = LuceneReader.createLuceneWildcards(criteria.getWords().toLowerCase());
        for (String word : words) {
            QueryParser qParser = new QueryParser(LUCENE_VERSION, "desc", (Analyzer)ANALYZER);
            qParser.setDefaultOperator(QueryParser.Operator.OR);
            qParser.setAllowLeadingWildcard(true);
            Query q2 = qParser.parse(word);
            bQuery.add(q2, BooleanClause.Occur.MUST);
        }
        if (criteria.getCategory() != null) {
            q = LuceneReader.getTermInt("category", criteria.getCategory().getId());
            bQuery.add(q, criteria.isCategoryNegation() ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST);
        }
        if (criteria.getOperation() != null) {
            q = LuceneReader.getTermLong("operation", criteria.getOperation().getId());
            bQuery.add(q, criteria.isOperationNegation() ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST);
        }
        if (criteria.getStatus() != null) {
            q = LuceneReader.getTermLong("state", criteria.getStatus().getId());
            bQuery.add(q, criteria.isStatusNegation() ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST);
        }
        if (criteria.getStart() != null || criteria.getEnd() != null) {
            Long start = criteria.getStart() == null ? null : Long.valueOf(criteria.getStart().getTime());
            Long end = criteria.getEnd() == null ? null : Long.valueOf(criteria.getEnd().getTime());
            NumericRangeQuery range = NumericRangeQuery.newLongRange((String)"indexDate", (Long)start, (Long)end, (boolean)true, (boolean)true);
            bQuery.add((Query)range, BooleanClause.Occur.MUST);
        }
        return bQuery;
    }

    private static Query getTermInt(String field, int value) {
        BytesRef bytes = new BytesRef(6);
        NumericUtils.intToPrefixCoded((int)value, (int)0, (BytesRef)bytes);
        Term term = new Term(field, bytes);
        return new TermQuery(term);
    }

    private static Query getTermLong(String field, long value) {
        BytesRef bytes = new BytesRef(11);
        NumericUtils.longToPrefixCoded((long)value, (int)0, (BytesRef)bytes);
        Term term = new Term(field, bytes);
        return new TermQuery(term);
    }
}

