/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.eindexer.utils.Utils;

public abstract class LuceneBase {
    protected static final Version LUCENE_VERSION = Version.LUCENE_43;
    protected static final StandardAnalyzer ANALYZER = new StandardAnalyzer(LUCENE_VERSION);
    protected static final String ID_FIELD = "index";
    protected static final String DESCRPTION_FIELD = "desc";
    protected static final String CATEGORY_FIELD = "category";
    protected static final String PATH_FIELD = "path";
    protected static final String INDEX_DATE_FIELD = "indexDate";
    protected static final String CREATE_DATE_FIELD = "createDate";
    protected static final String VERSION_FIELD = "version";
    protected static final String OPERATION_FIELD = "operation";
    protected static final String STATE_FIELD = "state";
    protected static final String FILE_LAST_MODIF_FIELD = "fileLM";
    protected static final String FILE_LENGTH_FIELD = "fileLength";
    protected static final String FILE_CRC_FIELD = "fileCRC";
    public static final int MIN_STR_LENGTH = 2;

    public Directory openIndex(TypeOfIndexEnum indexType) throws IOException {
        File fDir = Utils.getOutputDir(indexType);
        if (!fDir.exists()) {
            fDir.mkdirs();
        }
        if (!fDir.exists()) {
            throw new RuntimeException("Direcotry '" + fDir.getAbsolutePath() + "' not exist!");
        }
        FSDirectory index = FSDirectory.open((File)fDir);
        return index;
    }

    public static List<String> createLuceneWildcards(String wordsAsStr) {
        return LuceneBase.createLuceneWildcards(Utils.stringTokenizer(wordsAsStr));
    }

    public static List<String> createLuceneWildcards(List<String> words) {
        ArrayList<String> listWildcards = new ArrayList<String>();
        for (String word : words) {
            if (word.length() > 2) {
                word = word + "*";
            }
            listWildcards.add(word);
        }
        return listWildcards;
    }
}

