/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;

public class ZipUtils {
    public static File[] getFileList(File fBackupDir) {
        File[] listFiles = fBackupDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File path, String name) {
                return !name.endsWith(".zip");
            }
        });
        return listFiles;
    }

    public static void compreseDir(File fBackupDir, JProgressBar progressBar, JProgressBar progressBarD) {
        File[] listFiles = ZipUtils.getFileList(fBackupDir);
        if (progressBar != null) {
            progressBar.setMaximum(listFiles.length > 0 ? listFiles.length : 100);
            if (listFiles.length == 0) {
                progressBar.setValue(100);
            }
        }
        if (listFiles.length == 0) {
            return;
        }
        SimpleDateFormat formater = new SimpleDateFormat("_yyyyMMdd_HHmmss");
        ZipUtils.generateZipFile(listFiles, fBackupDir, "bkp" + formater.format(new Date()) + ".zip", progressBar);
        ZipUtils.cleanFiles(listFiles, progressBarD);
    }

    public static void cleanFiles(File[] listFiles, JProgressBar progressBar) {
        if (progressBar != null) {
            progressBar.setMaximum(listFiles.length > 0 ? listFiles.length : 100);
            if (listFiles.length == 0) {
                progressBar.setValue(100);
            }
        }
        int count = 0;
        for (File f : listFiles) {
            f.delete();
            ++count;
            if (progressBar == null) continue;
            progressBar.setValue(count);
        }
    }

    private static void generateZipFile(File[] listFiles, File destDir, String zipFilename, JProgressBar progressBar) {
        byte[] buf = new byte[1024];
        try {
            destDir.mkdirs();
            String zipFullFilename = new File(destDir, zipFilename).getAbsolutePath();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFullFilename));
            int count = 0;
            for (File filename : listFiles) {
                int len;
                FileInputStream in = new FileInputStream(filename);
                out.putNextEntry(new ZipEntry(filename.getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++count;
                if (progressBar == null) continue;
                progressBar.setValue(count);
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

