/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public final class EdgeNGramTokenFilter
extends TokenFilter {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private final int minGram;
    private final int maxGram;
    private Side side;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curGramSize;
    private int tokStart;
    private int tokEnd;
    private boolean hasIllegalOffsets;
    private int savePosIncr;
    private boolean isFirstToken = true;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    public EdgeNGramTokenFilter(TokenStream input, Side side, int minGram, int maxGram) {
        super(input);
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
    }

    public EdgeNGramTokenFilter(TokenStream input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.buffer().clone();
                this.curTermLength = this.termAtt.length();
                this.curGramSize = this.minGram;
                this.tokStart = this.offsetAtt.startOffset();
                this.tokEnd = this.offsetAtt.endOffset();
                this.hasIllegalOffsets = this.tokStart + this.curTermLength != this.tokEnd;
                this.savePosIncr = this.posIncrAtt.getPositionIncrement();
            }
            if (this.curGramSize <= this.maxGram && this.curGramSize <= this.curTermLength) {
                int start = this.side == Side.FRONT ? 0 : this.curTermLength - this.curGramSize;
                int end = start + this.curGramSize;
                this.clearAttributes();
                if (this.hasIllegalOffsets) {
                    this.offsetAtt.setOffset(this.tokStart, this.tokEnd);
                } else {
                    this.offsetAtt.setOffset(this.tokStart + start, this.tokStart + end);
                }
                if (this.curGramSize == this.minGram) {
                    if (!this.isFirstToken) {
                        this.posIncrAtt.setPositionIncrement(this.savePosIncr);
                    }
                } else {
                    this.posIncrAtt.setPositionIncrement(0);
                }
                this.termAtt.copyBuffer(this.curTermBuffer, start, this.curGramSize);
                ++this.curGramSize;
                this.isFirstToken = false;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
        this.isFirstToken = true;
    }

    public static enum Side {
        FRONT{

            @Override
            public String getLabel() {
                return "front";
            }
        }
        ,
        BACK{

            @Override
            public String getLabel() {
                return "back";
            }
        };


        public abstract String getLabel();

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

