/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer.table;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sk.rastsoft.eindexer.EditEntry;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.table.MyTableModel;

public class TableIndex {
    protected static final int DOUBLE_CLICK = 2;
    private MyTableModel myTableModel;
    private JTable table;
    private int selRow = -1;

    public JScrollPane addCompomemnt(List<RecordDataDTO> list, int w, int h) {
        this.myTableModel = new MyTableModel();
        this.setData(list, false);
        this.table = new JTable(this.myTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(w, h));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
        TableColumn column = null;
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            column = columnModel.getColumn(i);
            int size = this.myTableModel.getColumnSize(i);
            if (size != 0) {
                column.setPreferredWidth(size);
                continue;
            }
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setWidth(0);
            column.setPreferredWidth(0);
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int rowId = target.convertRowIndexToModel(row);
                TableIndex.this.selRow = row;
                if (e.getClickCount() == 2) {
                    System.out.println("Double click row:#" + rowId);
                    System.out.println("Row = " + row);
                    MyTableModel model = (MyTableModel)target.getModel();
                    RecordDataDTO item = model.getData().get(rowId);
                    new EditEntry("Edit", item.clone());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        return scrollPane;
    }

    public void setData(List<RecordDataDTO> list, boolean refresh) {
        this.myTableModel.setData(list);
        if (refresh) {
            this.myTableModel.fireTableDataChanged();
        }
    }

    public RecordDataDTO getSelItem() {
        if (this.selRow != -1 && this.selRow >= 0 && this.selRow < this.myTableModel.getData().size()) {
            return this.myTableModel.getData().get(this.selRow);
        }
        return null;
    }

    public int getSelRow() {
        return this.selRow;
    }

    public JTable getTable() {
        return this.table;
    }
}

