/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JTable;
import sk.rastsoft.eindexer.About;
import sk.rastsoft.eindexer.BackUpFrm;
import sk.rastsoft.eindexer.MainFrm;
import sk.rastsoft.eindexer.NewEntry;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.eindexer.table.MyTableModel;
import sk.rastsoft.eindexer.utils.NotifyHelper;
import sk.rastsoft.eindexer.utils.Utils;
import sk.rastsoft.lucene.defs.ILuceneWriter;

public class MainFrmMenu
implements ActionListener,
ItemListener {
    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainFrm mainFmr = NotifyHelper.getMainFmr();
        if (e.getSource() == mainFmr.getjDelButton()) {
            MainFrmMenu.deleteItem(mainFmr);
        } else if (e.getSource() == mainFmr.getMenuItemAbout()) {
            MainFrmMenu.about();
        } else if (e.getSource() == mainFmr.getjAddButton()) {
            MainFrmMenu.addItem();
        } else if (e.getSource() == mainFmr.getjBkpButton()) {
            MainFrmMenu.backupItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteItem(MainFrm mainFmr) {
        int dialogButton;
        JTable target = mainFmr.getTableIndex().getTable();
        int row = target.getSelectedRow();
        if (row == -1) {
            return;
        }
        int rowId = target.convertRowIndexToModel(row);
        MyTableModel model = (MyTableModel)target.getModel();
        RecordDataDTO item = model.getData().get(rowId);
        if (item != null && (dialogButton = Utils.showYNDialog("Delete", "Would You Like to delete entry '" + item.getDecription() + "'?")) == 0) {
            try {
                ILuceneWriter writer = Utils.getLuceneWriter(TypeOfIndexEnum.INDEX);
                writer.deleteData(item);
            }
            catch (Exception ex) {
                Utils.showDialog(ex.getClass().getSimpleName(), ex.getMessage());
            }
            finally {
                Utils.closeAll();
                mainFmr.reloadData();
            }
        }
    }

    private static void about() {
        new About();
    }

    private static void addItem() {
        new NewEntry("Add");
    }

    private static void backupItems() {
        Utils.closeAll();
        BackUpFrm bkpFrm = new BackUpFrm();
        bkpFrm.backupData();
    }
}

