/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.eindexer.literals.ISystem;
import sk.rastsoft.eindexer.utils.Utils;
import sk.rastsoft.eindexer.utils.ZipUtils;
import sk.rastsoft.lucene.defs.ILuceneReader;
import sk.rastsoft.lucene.defs.ILuceneWriter;
import sk.rastsoft.lucene.defs.SearchCriteria;

public class BackUpFrm
extends JFrame
implements ISystem {
    private static final long serialVersionUID = 754236056345821030L;
    private JProgressBar progressBarC;
    private JProgressBar progressBarD;
    private JProgressBar progressBarI;
    private JProgressBar progressBarD1;
    private JLabel jLabelIndex;

    public BackUpFrm() {
        this.setLayout(new GridBagLayout());
        this.setTitle("Backup entries");
        this.addElements(10, 10);
        this.setSize(410, 230);
        this.setVisible(true);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
    }

    private void addElements(int compresFilesCount, int backupCount) {
        int row = 0;
        JLabel jLabel = new JLabel("Clean folder");
        this.progressBarD = new JProgressBar(0, compresFilesCount);
        this.progressBarD.setPreferredSize(new Dimension(300, 15));
        this.progressBarD.setValue(0);
        this.progressBarD.setStringPainted(true);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)this.progressBarD, Utils.setGrid(1, row, 2));
        row = 1;
        this.jLabelIndex = new JLabel("Read index ...");
        this.add((Component)this.jLabelIndex, Utils.setGrid(0, row, 3));
        row = 2;
        jLabel = new JLabel("Backup");
        this.progressBarI = new JProgressBar(0, compresFilesCount);
        this.progressBarI.setPreferredSize(new Dimension(300, 15));
        this.progressBarI.setValue(0);
        this.progressBarI.setStringPainted(true);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)this.progressBarI, Utils.setGrid(1, row, 2));
        row = 3;
        jLabel = new JLabel("Compress");
        this.progressBarC = new JProgressBar(0, compresFilesCount);
        this.progressBarC.setPreferredSize(new Dimension(300, 15));
        this.progressBarC.setValue(0);
        this.progressBarC.setStringPainted(true);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)this.progressBarC, Utils.setGrid(1, row, 2));
        row = 4;
        jLabel = new JLabel("Clean index");
        this.progressBarD1 = new JProgressBar(0, compresFilesCount);
        this.progressBarD1.setPreferredSize(new Dimension(300, 15));
        this.progressBarD1.setValue(0);
        this.progressBarD1.setStringPainted(true);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)this.progressBarD1, Utils.setGrid(1, row, 2));
        row = 5;
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackUpFrm.this.setVisible(false);
                BackUpFrm.this.dispose();
            }
        });
        this.add((Component)jButton, Utils.setGrid(0, row, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupData() {
        File fBackupDir = Utils.getOutputDir(TypeOfIndexEnum.BACKUP);
        fBackupDir.mkdirs();
        String errorMsg = null;
        try {
            File[] listFiles = ZipUtils.getFileList(fBackupDir);
            ZipUtils.cleanFiles(listFiles, this.progressBarD);
            ILuceneReader reader = Utils.getLuceneReader(TypeOfIndexEnum.INDEX);
            ILuceneWriter writer = Utils.getLuceneWriter(TypeOfIndexEnum.BACKUP);
            SearchCriteria criteria = new SearchCriteria();
            criteria.setWords("*");
            criteria.setMaxItems(Integer.MAX_VALUE);
            List<RecordDataDTO> list = reader.searchData(criteria);
            this.jLabelIndex.setText("Readed " + list.size() + " items ...");
            this.progressBarI.setMaximum(list.size() > 0 ? list.size() : 100);
            if (list.size() == 0) {
                this.progressBarI.setValue(100);
            }
            int count = 0;
            for (RecordDataDTO item : list) {
                writer.addData(item);
                this.progressBarI.setValue(++count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMsg = e.getMessage();
        }
        finally {
            Utils.closeAll();
        }
        if (errorMsg == null) {
            ZipUtils.compreseDir(fBackupDir, this.progressBarC, this.progressBarD1);
            Utils.showDialog("Backup", "Backup done...");
        } else {
            Utils.showDialog("Error", errorMsg);
        }
    }

    public static void main(String[] args) {
        BackUpFrm bkpFrm = new BackUpFrm();
        bkpFrm.backupData();
    }
}

