/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.lucene.LuceneBase;
import sk.rastsoft.lucene.defs.ILuceneWriter;

public class LuceneWriter
extends LuceneBase
implements ILuceneWriter {
    private IndexWriter writer;

    public LuceneWriter(TypeOfIndexEnum indexType) {
        try {
            IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)ANALYZER);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this.writer = new IndexWriter(this.openIndex(indexType), config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addData(RecordDataDTO data) throws IOException {
        Integer dataVal = data.getDocId();
        if (dataVal == null) {
            data.setDocId(this.writer.maxDoc() + 1);
        }
        Document doc = LuceneWriter.getLuceneDocument(data);
        this.writer.addDocument((Iterable)doc);
        this.writer.commit();
    }

    @Override
    public void updateData(RecordDataDTO data) throws IOException {
        Term term = new Term("index", String.valueOf(data.getDocId()));
        Document doc = LuceneWriter.getLuceneDocument(data);
        this.writer.updateDocument(term, (Iterable)doc);
        this.writer.commit();
    }

    private static Document getLuceneDocument(RecordDataDTO data) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("index", String.valueOf(data.getDocId()), Field.Store.YES));
        doc.add((IndexableField)new IntField("version", data.getVersion().intValue(), Field.Store.YES));
        doc.add((IndexableField)new TextField("desc", data.getDecription(), Field.Store.YES));
        doc.add((IndexableField)new IntField("category", data.getCategory().getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("path", data.getFilePath(), Field.Store.YES));
        doc.add((IndexableField)new LongField("indexDate", data.getIndexDate().getTime(), Field.Store.YES));
        doc.add((IndexableField)new LongField("createDate", data.getCreationDate().getTime(), Field.Store.YES));
        doc.add((IndexableField)new LongField("operation", (long)data.getOpType().getId(), Field.Store.YES));
        doc.add((IndexableField)new LongField("fileLM", data.getLastModified(), Field.Store.YES));
        doc.add((IndexableField)new LongField("fileLength", data.getLength(), Field.Store.YES));
        doc.add((IndexableField)new LongField("fileCRC", data.getCrc(), Field.Store.YES));
        doc.add((IndexableField)new LongField("state", (long)data.getState().getId(), Field.Store.YES));
        return doc;
    }

    @Override
    public void deleteData(RecordDataDTO data) throws IOException {
        this.deleteData(data.getDocId());
    }

    @Override
    public void deleteData(int id) throws IOException {
        Term term = new Term("index", String.valueOf(id));
        this.writer.deleteDocuments(term);
        this.writer.commit();
        this.writer.deleteUnusedFiles();
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        this.writer = null;
    }
}

