/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer.utils;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import javax.swing.JOptionPane;
import sk.rastsoft.eindexer.dto.FileInfoDTO;
import sk.rastsoft.eindexer.enums.GroupTypeEnum;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.lucene.LuceneReader;
import sk.rastsoft.lucene.LuceneWriter;
import sk.rastsoft.lucene.defs.ILuceneReader;
import sk.rastsoft.lucene.defs.ILuceneWriter;

public class Utils {
    public static boolean aboutDialog = false;
    public static boolean searchDialog = false;
    private static Map<TypeOfIndexEnum, ILuceneReader> readers = new HashMap<TypeOfIndexEnum, ILuceneReader>();
    private static Map<TypeOfIndexEnum, ILuceneWriter> writers = new HashMap<TypeOfIndexEnum, ILuceneWriter>();

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        if (Utils.isEmpty(str)) {
            return true;
        }
        String str1 = str.replaceAll("\\s+", "");
        return Utils.isEmpty(str1);
    }

    public static List<String> stringTokenizer(String str) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static void showDialog(String title, String msg) {
        if (title == null) {
            title = "Runtime error";
        }
        if (msg == null) {
            msg = "null";
        }
        JOptionPane.showMessageDialog(null, "Message: " + msg, title, -1);
    }

    public static int showYNDialog(String title, String msg) {
        return JOptionPane.showConfirmDialog(null, msg, title, 0);
    }

    public static FileInfoDTO getFileInformations(String file) {
        FileInfoDTO fileInfo = new FileInfoDTO();
        try {
            File f = new File(file);
            fileInfo.setPath(file);
            fileInfo.setLastModified(f.lastModified());
            fileInfo.setLength(f.length());
            FileInputStream fis = new FileInputStream(file);
            CRC32 crc = new CRC32();
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                crc.update(dataBytes, 0, nread);
            }
            fileInfo.setCrc(crc.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return fileInfo;
    }

    public static File getOutputDir(TypeOfIndexEnum indexType) {
        File fDir = new File(System.getProperty("user.dir"), indexType.getDir());
        return fDir;
    }

    public static GridBagConstraints setGrid(int posX, int posY) {
        return Utils.setGrid(posX, posY, 1);
    }

    public static GridBagConstraints setGrid(int posX, int posY, int width) {
        GridBagConstraints gridPos = new GridBagConstraints();
        gridPos.gridx = posX;
        gridPos.gridy = posY;
        gridPos.gridwidth = width;
        gridPos.insets = new Insets(5, 5, 5, 5);
        return gridPos;
    }

    public static String[] getCategories() {
        String[] cats = new String[GroupTypeEnum.values().length];
        int index = 0;
        for (GroupTypeEnum cat : GroupTypeEnum.values()) {
            cats[index++] = cat.toString();
        }
        return cats;
    }

    public static String[] getSearchCategories() {
        String[] cats = new String[2 * GroupTypeEnum.values().length + 1];
        cats[0] = "---- not set ----";
        int index = 1;
        for (GroupTypeEnum cat : GroupTypeEnum.values()) {
            cats[index++] = cat.toString();
        }
        for (GroupTypeEnum cat : GroupTypeEnum.values()) {
            cats[index++] = "NOT (" + cat.toString() + ")";
        }
        return cats;
    }

    public static ILuceneReader getLuceneReader(TypeOfIndexEnum index) {
        ILuceneReader iLuceneReader = readers.get((Object)index);
        if (iLuceneReader == null) {
            iLuceneReader = new LuceneReader(index);
            readers.put(index, iLuceneReader);
        }
        return iLuceneReader;
    }

    public static ILuceneWriter getLuceneWriter(TypeOfIndexEnum index) {
        ILuceneWriter iLuceneWriter = writers.get((Object)index);
        if (iLuceneWriter == null) {
            iLuceneWriter = new LuceneWriter(index);
            writers.put(index, iLuceneWriter);
        }
        return iLuceneWriter;
    }

    public static void resetReaders() {
        for (ILuceneReader reader : readers.values()) {
            reader.close();
        }
        readers.clear();
    }

    public static void closeAll() {
        for (ILuceneWriter writer : writers.values()) {
            writer.close();
        }
        writers.clear();
        for (ILuceneReader reader : readers.values()) {
            reader.close();
        }
        readers.clear();
    }
}

