/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer.table;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.literals.ISystem;

public class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1634003865493013139L;
    public static final int POS_DESC = 0;
    public static final int POS_CATEGORY = 1;
    public static final int POS_OPERATION = 2;
    public static final int POS_STATUS = 3;
    public static final int POS_FILE_PATH = 4;
    public static final int POS_DATE = 5;
    public static final int POS_ID = 6;
    String[] columnNames = new String[]{"Description", "Category", "Operation", "Status", "File", "Date", "Id"};
    int[] columnSize = new int[]{200, 30, 30, 30, 150, 50, 0};
    List<RecordDataDTO> list;

    public void setData(List<RecordDataDTO> list) {
        this.list = list;
    }

    public List<RecordDataDTO> getData() {
        return this.list;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.list.size()) {
            return "";
        }
        RecordDataDTO data = this.list.get(rowIndex);
        if (data == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return data.getDecription();
            }
            case 1: {
                return data.getCategory();
            }
            case 2: {
                return data.getOpType();
            }
            case 3: {
                return data.getState();
            }
            case 4: {
                return data.getFilePath();
            }
            case 5: {
                return ISystem.sdf.format(data.getIndexDate());
            }
            case 6: {
                return data.getDocId();
            }
        }
        throw new RuntimeException("Not supported column!");
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public int getColumnSize(int columnIndex) {
        return this.columnSize[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

