/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import sk.rastsoft.eindexer.MainFrmMenu;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.enums.GroupTypeEnum;
import sk.rastsoft.eindexer.enums.IIndexableEnum;
import sk.rastsoft.eindexer.enums.OperationTypeEnum;
import sk.rastsoft.eindexer.enums.StatusTypeEnum;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.eindexer.literals.ISystem;
import sk.rastsoft.eindexer.table.TableIndex;
import sk.rastsoft.eindexer.utils.NotifyHelper;
import sk.rastsoft.eindexer.utils.Utils;
import sk.rastsoft.lucene.defs.ILuceneReader;
import sk.rastsoft.lucene.defs.SearchCriteria;

public class MainFrm
extends JFrame
implements ISystem {
    private static final long serialVersionUID = 1197608731810708260L;
    private List<RecordDataDTO> list;
    private TableIndex table;
    private SearchCriteria criteria;
    private JButton jAddButton;
    private JButton jDelButton;
    private JButton jBkpButton;
    private JMenuItem menuItemAbout;
    private JTextField jTestFieldC;

    public MainFrm() {
        this.setLayout(new GridBagLayout());
        this.setTitle("E-Indexer ver. 1.2");
        this.readCurrentData();
        this.addElements();
        this.addMenu();
        this.setSize(900, 500);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        NotifyHelper.registre(this.getClass(), this);
    }

    private void readCurrentData() {
        ILuceneReader reader = Utils.getLuceneReader(TypeOfIndexEnum.INDEX);
        try {
            if (this.criteria == null) {
                this.criteria = new SearchCriteria();
                this.criteria.setWords("*");
            }
            this.list = reader.searchData(this.criteria);
            this.showCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.showDialog(null, e.getMessage());
        }
    }

    private void addElements() {
        int row = 0;
        JLabel jLabel = new JLabel("Search");
        final JTextField jTestFieldS = new JTextField(55);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)jTestFieldS, Utils.setGrid(1, row, 3));
        JButton jSearchButton = new JButton("Search");
        this.add((Component)jSearchButton, Utils.setGrid(4, row));
        row = 1;
        final JComboBox<String> comboTypesList = new JComboBox<String>(Utils.getSearchCategories());
        comboTypesList.setSelectedIndex(0);
        this.add(comboTypesList, Utils.setGrid(0, row, 1));
        String[] ops = new String[2 * OperationTypeEnum.values().length + 1];
        ops[0] = "---- not set ----";
        int index = 1;
        for (OperationTypeEnum op : OperationTypeEnum.values()) {
            ops[index++] = op.toString();
        }
        for (OperationTypeEnum op : OperationTypeEnum.values()) {
            ops[index++] = "NOT (" + op.toString() + ")";
        }
        final JComboBox<String> comboOpTypes = new JComboBox<String>(ops);
        comboOpTypes.setSelectedIndex(0);
        this.add(comboOpTypes, Utils.setGrid(1, row, 1));
        String[] states = new String[2 * StatusTypeEnum.values().length + 1];
        states[0] = "---- not set ----";
        int index1 = 1;
        for (StatusTypeEnum state : StatusTypeEnum.values()) {
            states[index1++] = state.toString();
        }
        for (StatusTypeEnum state : StatusTypeEnum.values()) {
            states[index1++] = "NOT (" + state.toString() + ")";
        }
        final JComboBox<String> comboStateTypes = new JComboBox<String>(states);
        comboStateTypes.setSelectedIndex(0);
        this.add(comboStateTypes, Utils.setGrid(2, row, 1));
        final JTextField jTestFieldStart = new JTextField(11);
        jTestFieldStart.setToolTipText("Start date format: dd.mm.yyyy hh:mm:ss");
        this.add((Component)jTestFieldStart, Utils.setGrid(3, row));
        final JTextField jTestFieldEnd = new JTextField(11);
        jTestFieldEnd.setToolTipText("End date format: dd.mm.yyyy hh:mm:ss");
        this.add((Component)jTestFieldEnd, Utils.setGrid(4, row));
        row = 2;
        this.table = new TableIndex();
        JScrollPane panel = this.table.addCompomemnt(this.list, 840, 240);
        this.add((Component)panel, Utils.setGrid(0, row, 5));
        row = 3;
        jLabel = new JLabel("Items found");
        this.jTestFieldC = new JTextField(5);
        this.jTestFieldC.setEditable(false);
        this.jTestFieldC.setHorizontalAlignment(0);
        this.jTestFieldC.setText("0");
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)this.jTestFieldC, Utils.setGrid(1, row));
        row = 4;
        this.jAddButton = new JButton("Add");
        this.jAddButton.addActionListener(new MainFrmMenu());
        this.add((Component)this.jAddButton, Utils.setGrid(0, row));
        this.jDelButton = new JButton("Delete");
        this.jDelButton.addActionListener(new MainFrmMenu());
        this.add((Component)this.jDelButton, Utils.setGrid(1, row));
        this.jBkpButton = new JButton("Backup");
        this.jBkpButton.addActionListener(new MainFrmMenu());
        this.add((Component)this.jBkpButton, Utils.setGrid(3, row));
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.closeAll();
                MainFrm.this.setVisible(false);
                MainFrm.this.dispose();
            }
        });
        this.add((Component)jButton, Utils.setGrid(4, row));
        jSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String txt = jTestFieldS.getText();
                int posG = comboTypesList.getSelectedIndex();
                int posO = comboOpTypes.getSelectedIndex();
                int posS = comboStateTypes.getSelectedIndex();
                String startDateStr = jTestFieldStart.getText();
                String endDateStr = jTestFieldEnd.getText();
                try {
                    SearchCriteria crit = new SearchCriteria();
                    crit.setWords(Utils.isBlank(txt) ? "*" : txt);
                    crit.setCategory(this.getEnum(posG, GroupTypeEnum.values()));
                    crit.setCategoryNegation(this.getEnumNegation(posG, GroupTypeEnum.values().length));
                    crit.setOperation(this.getEnum(posO, OperationTypeEnum.values()));
                    crit.setOperationNegation(this.getEnumNegation(posO, OperationTypeEnum.values().length));
                    crit.setStatus(this.getEnum(posS, StatusTypeEnum.values()));
                    crit.setStatusNegation(this.getEnumNegation(posS, StatusTypeEnum.values().length));
                    crit.setStart(this.getDate(startDateStr));
                    crit.setEnd(this.getDate(endDateStr));
                    MainFrm.this.criteria = crit;
                }
                catch (Exception ex) {
                    Utils.showDialog("Error found", "Problem : " + ex.getMessage());
                    MainFrm.this.criteria = null;
                }
                MainFrm.this.reloadData();
            }

            private IIndexableEnum getEnum(int pos, IIndexableEnum[] objs) {
                if (pos == 0) {
                    return null;
                }
                int index = 1;
                for (IIndexableEnum obj : objs) {
                    if (pos == index) {
                        return obj;
                    }
                    ++index;
                }
                for (IIndexableEnum obj : objs) {
                    if (pos == index) {
                        return obj;
                    }
                    ++index;
                }
                return null;
            }

            private boolean getEnumNegation(int pos, int length) {
                return pos > length;
            }

            private Date getDate(String dateStr) throws ParseException {
                if (Utils.isBlank(dateStr)) {
                    return null;
                }
                return ISystem.sdfLong.parse(dateStr);
            }
        });
        this.showCount();
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Info");
        menu.setMnemonic(73);
        menuBar.add(menu);
        this.menuItemAbout = new JMenuItem("About", 65);
        this.menuItemAbout.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.menuItemAbout.getAccessibleContext().setAccessibleDescription("About ...");
        this.menuItemAbout.addActionListener(new MainFrmMenu());
        menu.add(this.menuItemAbout);
        this.setJMenuBar(menuBar);
    }

    private void showCount() {
        if (this.jTestFieldC == null) {
            return;
        }
        if (this.list != null) {
            this.jTestFieldC.setText(String.valueOf(this.list.size()));
        } else {
            this.jTestFieldC.setText("0");
        }
    }

    public void reloadData() {
        this.readCurrentData();
        this.table.setData(this.list, true);
    }

    public TableIndex getTableIndex() {
        return this.table;
    }

    public JButton getjAddButton() {
        return this.jAddButton;
    }

    public JButton getjDelButton() {
        return this.jDelButton;
    }

    public JButton getjBkpButton() {
        return this.jBkpButton;
    }

    public JMenuItem getMenuItemAbout() {
        return this.menuItemAbout;
    }

    public JTextField getjTestFieldC() {
        return this.jTestFieldC;
    }

    public static void main(String[] args) {
        new MainFrm();
    }
}

