/*
 * Decompiled with CFR 0.152.
 */
package sk.rastsoft.eindexer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sk.rastsoft.eindexer.dto.FileInfoDTO;
import sk.rastsoft.eindexer.dto.RecordDataDTO;
import sk.rastsoft.eindexer.enums.GroupTypeEnum;
import sk.rastsoft.eindexer.enums.OperationTypeEnum;
import sk.rastsoft.eindexer.enums.StatusTypeEnum;
import sk.rastsoft.eindexer.enums.TypeOfIndexEnum;
import sk.rastsoft.eindexer.literals.ISystem;
import sk.rastsoft.eindexer.utils.NotifyHelper;
import sk.rastsoft.eindexer.utils.Utils;
import sk.rastsoft.lucene.defs.ILuceneWriter;

public class EditEntry
extends JFrame
implements ISystem {
    private static final long serialVersionUID = 7538842158067770911L;
    private RecordDataDTO item;

    public EditEntry(String prefix, RecordDataDTO item) {
        this.item = item;
        this.setLayout(new GridBagLayout());
        this.setTitle(prefix + " entry");
        this.addElements();
        this.setSize(500, 300);
        this.setVisible(true);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    private void addElements() {
        String currentDate = sdf.format(new Date());
        String currentDateLong = sdfLong.format(this.item.getCreationDate());
        int row = 0;
        JLabel jLabel = new JLabel("ID");
        JTextField jIdField = new JTextField(6);
        jIdField.setEditable(false);
        jIdField.setHorizontalAlignment(0);
        jIdField.setText("#" + String.valueOf(this.item.getDocId()));
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)jIdField, Utils.setGrid(1, row));
        jLabel = new JLabel("Version");
        JTextField jVersionField = new JTextField(3);
        jVersionField.setEditable(false);
        jVersionField.setHorizontalAlignment(0);
        jVersionField.setText(String.valueOf(this.item.getVersion()));
        this.add((Component)jLabel, Utils.setGrid(3, row));
        this.add((Component)jVersionField, Utils.setGrid(4, row));
        row = 1;
        jLabel = new JLabel("Description");
        final JTextField jTestFieldD = new JTextField(30);
        jTestFieldD.setText(this.item.getDecription());
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)jTestFieldD, Utils.setGrid(1, row, 4));
        row = 5;
        jLabel = new JLabel("File");
        JTextField jTestField = new JTextField(20);
        jTestField.setText(this.item.getFilePath());
        final JTextField jTestFieldFile = jTestField;
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (0 == chooser.showOpenDialog(null)) {
                    String filePath = chooser.getSelectedFile().getAbsolutePath();
                    jTestFieldFile.setText(filePath);
                    EditEntry.this.item.setFilePath(filePath);
                    EditEntry.fillDataWithFileInfos(EditEntry.this.item);
                }
            }
        });
        Dimension size = jTestField.getPreferredSize();
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)jTestField, Utils.setGrid(1, row, 3));
        this.add((Component)jButton, Utils.setGrid(4, row));
        row = 2;
        jLabel = new JLabel("Category");
        final JComboBox<String> comboTypesList = new JComboBox<String>(Utils.getCategories());
        comboTypesList.setSelectedIndex(this.item.getCategory().getId());
        Dimension sizeCombo = comboTypesList.getPreferredSize();
        sizeCombo.width = size.width;
        comboTypesList.setPreferredSize(size);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add(comboTypesList, Utils.setGrid(1, row, 3));
        row = 3;
        jLabel = new JLabel("Operation");
        String[] ops = new String[OperationTypeEnum.values().length];
        int index = 0;
        for (OperationTypeEnum op : OperationTypeEnum.values()) {
            ops[index++] = op.toString();
        }
        final JComboBox<String> comboOpTypes = new JComboBox<String>(ops);
        comboOpTypes.setSelectedIndex(this.item.getOpType().getPos());
        sizeCombo = comboOpTypes.getPreferredSize();
        sizeCombo.width = size.width;
        comboOpTypes.setPreferredSize(size);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add(comboOpTypes, Utils.setGrid(1, row, 3));
        row = 4;
        jLabel = new JLabel("State");
        String[] states = new String[StatusTypeEnum.values().length];
        int index1 = 0;
        for (StatusTypeEnum state : StatusTypeEnum.values()) {
            states[index1++] = state.toString();
        }
        final JComboBox<String> comboStateTypes = new JComboBox<String>(states);
        comboStateTypes.setSelectedIndex(this.item.getState().getId() + 1);
        sizeCombo = comboStateTypes.getPreferredSize();
        sizeCombo.width = size.width;
        comboStateTypes.setPreferredSize(size);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add(comboStateTypes, Utils.setGrid(1, row, 3));
        row = 6;
        jLabel = new JLabel("Modify date");
        final JTextField jTestFieldI = new JTextField(8);
        jTestFieldI.setText(currentDate);
        this.add((Component)jLabel, Utils.setGrid(0, row));
        this.add((Component)jTestFieldI, Utils.setGrid(1, row));
        jLabel = new JLabel("Creation date");
        final JTextField jTestFieldC = new JTextField(11);
        jTestFieldC.setText(currentDateLong);
        jTestFieldC.setEditable(false);
        jTestFieldC.setHorizontalAlignment(0);
        this.add((Component)jLabel, Utils.setGrid(2, row));
        this.add((Component)jTestFieldC, Utils.setGrid(3, row, 2));
        row = 7;
        jButton = new JButton("Verify");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileInfoDTO fInfo = Utils.getFileInformations(jTestFieldFile.getText());
                    EditEntry.this.compareData(fInfo);
                    Utils.showDialog("Verification", "Status ok");
                }
                catch (Exception ex) {
                    Utils.showDialog(ex.getClass().getSimpleName(), ex.getMessage());
                }
            }
        });
        this.add((Component)jButton, Utils.setGrid(2, row));
        jButton = new JButton("Save");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ILuceneWriter writer = Utils.getLuceneWriter(TypeOfIndexEnum.INDEX);
                    RecordDataDTO data = EditEntry.this.item;
                    data.setDecription(jTestFieldD.getText());
                    data.setCategory(GroupTypeEnum.getType(comboTypesList.getSelectedIndex()));
                    data.setOpType(OperationTypeEnum.getType(comboOpTypes.getSelectedIndex() - 1));
                    data.setState(StatusTypeEnum.getType(comboStateTypes.getSelectedIndex() - 1));
                    data.setFilePath(jTestFieldFile.getText());
                    data.setIndexDate(ISystem.sdf.parse(jTestFieldI.getText()));
                    data.setCreationDate(ISystem.sdfLong.parse(jTestFieldC.getText()));
                    EditEntry.validateData(data);
                    FileInfoDTO fInfo = Utils.getFileInformations(data.getFilePath());
                    EditEntry.this.compareData(fInfo);
                    writer.updateData(data);
                    EditEntry.this.setVisible(false);
                    EditEntry.this.dispose();
                    NotifyHelper.reloadData();
                }
                catch (Exception ex) {
                    Utils.showDialog(ex.getClass().getSimpleName(), ex.getMessage());
                }
            }
        });
        this.add((Component)jButton, Utils.setGrid(3, row));
        jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditEntry.this.setVisible(false);
                EditEntry.this.dispose();
            }
        });
        this.add((Component)jButton, Utils.setGrid(4, row));
    }

    private static void validateData(RecordDataDTO data) {
        if (Utils.isBlank(data.getDecription())) {
            throw new RuntimeException("Description is empty!");
        }
        if (GroupTypeEnum.Unknown.equals(data.getCategory())) {
            throw new RuntimeException("Category not set!");
        }
        if (OperationTypeEnum.Unknown.equals(data.getOpType())) {
            throw new RuntimeException("Operation not set!");
        }
        if (StatusTypeEnum.Unknown.equals(data.getState())) {
            throw new RuntimeException("State not set!");
        }
        if (Utils.isBlank(data.getFilePath())) {
            throw new RuntimeException("File is empty!");
        }
    }

    private static void fillDataWithFileInfos(RecordDataDTO data) {
        FileInfoDTO fInfo = Utils.getFileInformations(data.getFilePath());
        data.setLastModified(fInfo.getLastModified());
        data.setLength(fInfo.getLength());
        data.setCrc(fInfo.getCrc());
    }

    private void compareData(FileInfoDTO fInfo) {
        int choice;
        String str;
        long l2;
        long l1 = this.item.getLength();
        if (l1 != (l2 = fInfo.getLength())) {
            str = "File length mismatch (" + l1 + " / " + l2 + ")!";
            choice = Utils.showYNDialog("Warning", str + " Update item?");
            if (choice == 0) {
                this.item.setLength(fInfo.getLength());
            } else {
                throw new RuntimeException(str);
            }
        }
        if ((l1 = this.item.getLastModified()) != (l2 = fInfo.getLastModified())) {
            str = "File timestamp mismatch (" + l1 + " / " + l2 + ")!";
            choice = Utils.showYNDialog("Warning", str + " Update item?");
            if (choice == 0) {
                this.item.setLastModified(fInfo.getLastModified());
            } else {
                throw new RuntimeException(str);
            }
        }
        if ((l1 = this.item.getCrc()) != (l2 = fInfo.getCrc())) {
            str = "File CRC mismatch (" + l1 + " / " + l2 + ")!";
            choice = Utils.showYNDialog("Warning", str + " Update item?");
            if (choice == 0) {
                this.item.setCrc(fInfo.getCrc());
            } else {
                throw new RuntimeException(str);
            }
        }
    }

    public static void main(String[] args) {
        RecordDataDTO item = new RecordDataDTO();
        item.setDecription("decription");
        item.setCategory(GroupTypeEnum.Company);
        item.setFilePath("filePath");
        item.setIndexDate(new Date());
        item.setCreationDate(new Date());
        item.setDocId(123);
        item.setOpType(OperationTypeEnum.Neutral);
        item.setState(StatusTypeEnum.Created);
        item.setLastModified(21L);
        item.setLength(1L);
        item.setCrc(12345L);
        new EditEntry("Edit", item);
    }
}

